//------------------------------------------------------------------
//  d3Scale.js
//  Copyright 2014 Applied Invention, LLC.
//------------------------------------------------------------------

import * as d3 from "d3";

//------------------------------------------------------------------
// Functions
//------------------------------------------------------------------

/** Creates a new D3 scale object that is a copy of an existing scale object.
 *
 * @param src The D3 scale object to copy from.
 * @param createFunc (Optional) The function to call to create the new object.
 *                   If not provided, d3.scale.linear() will be called.
 *
 * @return A new D3 scale object.
 */
export
function createCopy<T, U, V>(src: d3.ScaleLinear<T, U, V>,
                             createFunc?: () => d3.ScaleLinear<T, U, V>) :
  d3.ScaleLinear<T, U, V>
{
  if (!createFunc)
  {
    createFunc = d3.scaleLinear;
  }
  let ret = createFunc();

  copy(src, ret);

  return ret;
}

/** Copies the domain and range from one scale object to another.
 *
 * @param src The D3 scale object to copy from.
 * @param dest The D3 scale object to copy to
 */
export function copy<T, U, V>(src: d3.ScaleLinear<T, U, V>,
                              dest: d3.ScaleLinear<T, U, V>) : void
{
  dest.domain(src.domain());
  dest.range(src.range());
}
