//------------------------------------------------------------------
//  assert.ts
//  Copyright 2013 AppliedMinds, Inc.
//------------------------------------------------------------------

//------------------------------------------------------------------
// Functions
//------------------------------------------------------------------

/** Writes an error message if a condition fails.
 *
 * Here's an example:
 *
 *   import { assert } from '../axe/util/assert';
 *
 *   assert(myStr == "ok",
 *          "Foo.bar",
 *          "I expected myStr to be 'ok', but it's actually '",
 *          myStr,
 *          "'.");
 *
 * @param condition The condition that must be true.
 * @param msg  Comma-separated pieces of an error message to be printed.
 *             This is a pseudo-varargs list.
 *             All these messages will be concatenated into an error message.
 */
export function assert(condition: boolean, ...msg: Array<any>) : void
{
  if (!condition) {

    let msgHeader = "ASSERT FAILED: ";

    let msgSegs: Array<string> = [];
    for (let i = 0; i < msg.length; ++i)
    {
      msgSegs.push("" + msg[i]);
    }
    msgSegs.unshift(msgHeader);

    // Write to the console to get pretty printed objects.
    if (typeof console != 'undefined')
    {
      console.error.apply(console, msgSegs);
    }

    throw new Error(msgSegs.join(" "));
  }
}
