//------------------------------------------------------------------
//  TestJsonPrimitiveType.ts
//  Copyright 2016 Applied Invention, LLC
//------------------------------------------------------------------

//------------------------------------------------------------------
import * as axeString from "../../../util/string";
import { UnitTest } from '../../../unittest/UnitTest';
import { UnitTestRunner } from '../../../unittest/UnitTestRunner';
import { JsonPrimitiveType } from '../JsonPrimitiveType';
import { JsonType } from '../JsonType';
//------------------------------------------------------------------

/** Unit test for the JsonPrimitiveType class.
 */
export class TestJsonPrimitiveType extends UnitTest
{
  //----------------------------------------------------------------
  // Creation
  //----------------------------------------------------------------

  /** Creates a new JsonPrimitiveType object.
   */
  constructor()
  {
    super();
  }

  //------------------------------------------------------------------
  // Test Methods (name starts with 'test')
  //------------------------------------------------------------------

  /** Test the validate() method.
   */
  testValidate() : void
  {
    this.checkType('bool', true, 3.14);
    this.checkType('float', 3.14, 'invalid');
    this.checkType('int', 42, 'invalid');
    this.checkType('string', 'jim', 3.14);

    // Int is aliso valid for float.
    this.checkType('float', 3, 'invalid');

    // None is valid for anything.
    this.checkType('bool', null, 3.14);
  }

  /** Helper function to check the validate() method.
   */
  checkType(typeName: string, validValue: any, invalidValue: any) : void
  {
    let jsonType: JsonType = new JsonPrimitiveType(typeName);

    this.assertEqual(typeName + ' valid', null, jsonType.validate(validValue));
    this.assertEqual(typeName + ' json valid',
                     null, jsonType.validateJson(validValue));

    this.assertNotNull(typeName + ' invalid', jsonType.validate(invalidValue));

    this.assertEqual(typeName + ' valid JSON',
                     null, jsonType.validate(validValue));

    this.assertNotNull(typeName + ' invalid JSON',
                       jsonType.validate(invalidValue));


    this.assertEqual(typeName + ' encode',
                     validValue, jsonType.encode(validValue));

    this.assertEqual(typeName + ' decode',
                     validValue, jsonType.decode(validValue));

    this.assertEqual(typeName + ' decodeLinks',
                     validValue, jsonType.decodeLinks([], validValue));
  }

  //------------------------------------------------------------------
  // Private Helper Methods
  //------------------------------------------------------------------

} // END class TestJsonPrimitiveType

//------------------------------------------------------------------
// Register the test.
UnitTestRunner.add(new TestJsonPrimitiveType());
