//------------------------------------------------------------------
//  TestJsonDate.ts
//  Copyright 2016 Applied Invention, LLC
//------------------------------------------------------------------

//------------------------------------------------------------------
import * as axeString from "../../../util/string";
import { Day } from "../../../date/Day";
import { JsonDate } from "../JsonDate";
import { UnitTest } from "../../../unittest/UnitTest";
import { UnitTestRunner } from "../../../unittest/UnitTestRunner";
//------------------------------------------------------------------

/** Unit test for the JsonDate class.
 */
export class TestJsonDate extends UnitTest
{
  //----------------------------------------------------------------
  // Creation
  //----------------------------------------------------------------

  /** Creates a new JsonDate object.
   */
  constructor()
  {
    super();
  }

  //------------------------------------------------------------------
  // Test Methods (name starts with 'test')
  //------------------------------------------------------------------

  /** Test the encode/decode() method.
   */
  testEncodeDecode() : void
  {
    let jsonType = new JsonDate();

    // Validate typescript.

    this.assertEqual('date valid',
                     null, jsonType.validate(new Day(2016, 0, 2)));
    this.assertEqual('null valid', null, jsonType.validate(null));

    this.assertNotNull('string invalid', jsonType.validate('invalid'));
    this.assertNotNull('float invalid', jsonType.validate(3.14));

    // Validate JSON.

    this.assertEqual('date valid JSON',
                     null,
                     jsonType.validateJson("2016-01-01"));
    this.assertEqual('null valid JSON', null, jsonType.validateJson(null));

    this.assertNotNull('string invalid', jsonType.validateJson('invalid'));
    this.assertNotNull('float invalid', jsonType.validateJson(3.14));

    // Encode.

    this.assertEqual('encode',
                     "2016-01-02", jsonType.encode(new Day(2016, 0, 2)));
    this.assertEqual('null', null, jsonType.encode(null));

    // Decode.

    this.assertEqual('decode',
                     new Day(2016, 0, 2), jsonType.decode("2016-01-02"));
    this.assertEqual('null', null, jsonType.decode(null));

    // Decode links.

    this.assertEqual('decodeLinks',
                     new Day(2016, 1, 2),
                     jsonType.decodeLinks([], new Day(2016, 1, 2)));

    this.assertEqual('null', null, jsonType.decodeLinks([], null));
  }

  //------------------------------------------------------------------
  // Private Helper Methods
  //------------------------------------------------------------------

} // END class TestJsonDate

//------------------------------------------------------------------
// Register the test.
UnitTestRunner.add(new TestJsonDate());
